#include <bits/stdc++.h>

#define INF 1000000005
#define INFL 1000000000000000005ll
#define EPS 1e-6
#define pb push_back
#define pause system("pause")
#define exit exit(0)
#define endl '\n'

using namespace std;
using ull = unsigned long long;
using ll = long long;

typedef pair<ll, ll> pii;
const int N = 200005, MOD = 1e9 + 7;

mt19937 rng(time(NULL));
typedef struct node* pnode;
struct node {
	pnode l, r;
	int x, y, cnt;
	node (int x) : l(NULL), r(NULL), x(x), y(rng()), cnt(1) {}
};


int get_cnt(pnode t) {
	return t ? t->cnt : 0;
}

void upd_cnt(pnode t) {
	if (t) {
		t->cnt = get_cnt(t->l) + get_cnt(t->r) + 1;
	}
}

void merge(pnode &t, pnode l, pnode r) {
	if (!l || !r) {
		t = l ? l : r;
	} else if (l->y > r->y) {
		merge(l->r, l->r, r), t = l;
	} else {
		merge(r->l, l, r->l), t = r;
	}

	upd_cnt(t);
}

void split(pnode t, pnode &l, pnode &r, int x) {
	if (!t) {
		l = r = NULL;
	} else if (x < t->x) {
		split(t->l, l, t->l, x), r = t;
	} else {
		split(t->r, t->r, r, x), l = t;
	}

	upd_cnt(t);
}

pnode unite(pnode l, pnode r) {
	if (!l || !r) 
		return l ? l : r;
	if (l->y < r->y)
		swap(l, r);
	pnode lt, rt;
	split(r, lt, rt, l->x);
	l->l = unite(l->l, lt);
	l->r = unite(l->r, rt);
	return l;
}

int n, q;
pnode pos[5];
string s;

void dfs(pnode &t, char a) {
	if (!t) return;
	s[t->x] = a;
	dfs(t->l, a), dfs(t->r, a);
}

int main() {
	ios_base::sync_with_stdio(false);
	cin.tie(0), cout.tie(0);

	cin >> n >> q;
	cin >> s;
	for (int i = 0; i < 5; ++i) {
		pos[i] = NULL;
	}

	for (int i = 0; i < n; ++i) {
		int j = s[i] - 'a';
		merge(pos[j], pos[j], new node(i));
	}

	int x;
	char a, b;
	while (q--) {
		cin >> x >> a >> b;
		int l = -1, r = n + 1, m, j = a - 'a', k = b - 'a';
		pnode t1, t2;
		while (r - l > 1) {
			m = (l + r) >> 1;
			t1 = t2 = NULL;
			split(pos[j], t1, t2, m);
			if (get_cnt(t1) <= x) {
				l = m;
			} else {
				r = m;
			}
			merge(pos[j], t1, t2);
		}

		t1 = t2 = NULL;
		split(pos[j], t1, t2, l);
		pos[j] = t2;
		pos[k] = unite(pos[k], t1);
	}

	for (int j = 0; j < 5; ++j) {
		dfs(pos[j], 'a' + j);
	}

	cout << s << endl;
	//pause;
	return 0;
}
